#! /usr/bin/python

# To change this license header, choose License Headers in Project Properties.
# To change this template file, choose Tools | Templates
# and open the template in the editor.

__author__ = "Tomas Oberhuber"
__date__ = "$May 6, 2015 8:40:59 PM$"


def generateMakefile( problemBaseName ):
    file = open( "Makefile", "w" )
    file.write( "# Uncomment the following line to enable CUDA\n" )
    file.write( "#WITH_CUDA = yes\n" )
    file.write( "\n" ) 
    file.write( "TARGET = " + problemBaseName + "\n")
    file.write( "INSTALL_DIR = ${HOME}/local\n" )
    file.write( "\n" )
    file.write( "LDFLAGS = $(shell tnl-link )\n" )
    file.write( "\n" )
    file.write( "ifdef WITH_CUDA\n" )
    file.write( "   CXX = nvcc\n" )     
    file.write( "   CXX_FLAGS = $(shell tnl-compile --cuda)\n" )    
    file.write( "else\n" )                                  
    file.write( "   CXX = g++\n" ) 
    file.write( "   CXX_FLAGS = $(shell tnl-compile)\n" )    
    file.write( "endif\n" )                              
    file.write( "\n" )
    file.write( "SOURCES = " + problemBaseName + ".cpp\n" )
    file.write( "HEADERS = " + problemBaseName + ".h\n" )
    file.write( "OBJECTS = " + problemBaseName + ".o\n" ) 
    file.write( "DIST = $(SOURCES) $(CUDA_SOURCES) $(HEADERS) Makefile\n" ) 
    file.write( "\n" ) 
    file.write( "ifdef WITH_CUDA\n" )
    file.write( "   OBJECTS = " + problemBaseName + "-cuda.o\n" )     
    file.write( "endif\n" )     
    file.write( "\n" )     
    file.write( "all: $(TARGET)\n" ) 
    file.write( "\n" ) 
    file.write( "clean:\n" ) 
    file.write( "\t rm -f *.o" ) 
    file.write( "\n" ) 
    file.write( "dist: $(DIST)" ) 
    file.write( "\t tar zcvf $(TARGET).tgz $(DIST)\n" ) 
    file.write( "\n" ) 
    file.write( "$(TARGET): $(OBJECTS)\n" ) 
    file.write( "\t$(CXX) -o $@ $< $(LDFLAGS)\n" ) 
    file.write( "\n" ) 
    file.write( "%.o: %.cpp\n" ) 
    file.write( "\t $(CXX) $(CPPFLAGS) $(CXX_FLAGS) -c -o $@ $<" ) 
    file.write( "\n" ) 
    file.write( "%.o: %.cu\n" ) 
    file.write( "\t $(CXX) $(CPPFLAGS) $(CXX_FLAGS) -c -o $@ $<" )     
    file.close()

def generateMain( problemName, problemBaseName, operatorName ):
    file = open( problemBaseName + ".h", "w" )
    file.write( "#include <tnlConfig.h>\n" )
    file.write( "#include <solvers/tnlSolver.h>\n" )
    file.write( "#include <solvers/tnlBuildConfigTags.h>\n" )
    file.write( "#include <operators/tnlDirichletBoundaryConditions.h>\n" )
    file.write( "#include <operators/tnlNeumannBoundaryConditions.h>\n" )
    file.write( "#include <functions/ConstantFunction.h>\n" )
    file.write( "#include \"" + problemBaseName + "Problem.h\"\n" )
    file.write( "#include \"" + operatorName + ".h\"\n" )
    file.write( "#include \"" + problemBaseName + "Rhs.h\"\n" )
    file.write( "#include \"" + problemBaseName + "BuildConfigTag.h\"\n" )
    file.write( "\n" )
    file.write( "typedef " + problemBaseName + "BuildConfigTag BuildConfig;\n" )    
    file.write( "\n" )    
    file.write( "/****\n" )    
    file.write( " * Uncoment the following (and comment the previous line) for the complete build.\n" )    
    file.write( " * This will include support for all floating point precisions, all indexing types\n" )    
    file.write( " * and more solvers. You may then choose between them from the command line.\n" )    
    file.write( " * The compile time may, however, take tens of minutes or even several hours,\n" )    
    file.write( " * esppecially if CUDA is enabled. Use this, if you want, only for the final build,\n" )        
    file.write( " * not in the development phase.\n" )    
    file.write( " */\n" )    
    file.write( "//typedef tnlDefaultConfigTag BuildConfig;\n" )    
    file.write( "\n" )
    file.write( "template< typename ConfigTag >" )
    file.write( "class " + problemBaseName + "Config\n" )
    file.write( "{\n" )
    file.write( "   public:\n" )
    file.write( "      static void configSetup( tnlConfigDescription & config )\n" )
    file.write( "      {\n" )
    file.write( "         config.addDelimiter( \"" + problemName + " settings:\" );\n" )
    file.write( "         config.addEntry< tnlString >( \"boundary-conditions-type\", \"Choose the boundary conditions type.\", \"dirichlet\");\n" )
    file.write( "            config.addEntryEnum< tnlString >( \"dirichlet\" );\n" )
    file.write( "            config.addEntryEnum< tnlString >( \"neumann\" );\n" )
    file.write( "         config.addEntry< double >( \"boundary-conditions-constant\", \"This sets a value in case of the constant boundary conditions.\" );\n" )
    file.write( "\n" )
    file.write( "         /****\n" )
    file.write( "          * Add definition of your solver command line arguments.\n" )
    file.write( "          */\n" )
    file.write( "\n" )
    file.write( "      }\n" )
    file.write( "};\n" )
    file.write( "\n" )
    file.write( "template< typename Real,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename Index,\n" )
    file.write( "          typename MeshType,\n" )
    file.write( "          typename ConfigTag,\n" )
    file.write( "          typename SolverStarter >\n" )
    file.write( "class " + problemBaseName + "Setter\n" )
    file.write( "{\n" )
    file.write( "   public:\n" )
    file.write( "\n" )
    file.write( "      typedef Real RealType;\n" )
    file.write( "      typedef Device DeviceType;\n" )
    file.write( "      typedef Index IndexType;\n" )
    file.write( "\n" )
    file.write( "      static bool run( const tnlParameterContainer & parameters )\n" )
    file.write( "      {\n" )
    file.write( "          enum { Dimensions = MeshType::getMeshDimensions() };\n" )
    file.write( "          typedef " + operatorName + "< MeshType, Real, Index > ApproximateOperator;\n" )
    file.write( "          typedef " + problemBaseName + "Rhs< MeshType, Real > RightHandSide;\n" )    
    file.write( "          typedef tnlStaticVector < MeshType::getMeshDimensions(), Real > Vertex;\n" )
    file.write( "\n" )
    file.write( "         /****\n" )
    file.write( "          * Resolve the template arguments of your solver here.\n" )
    file.write( "          * The following code is for the Dirichlet and the Neumann boundary conditions.\n" )
    file.write( "          * Both can be constant or defined as descrete values of tnlVector.\n" )    
    file.write( "          */\n" )    
    file.write( "          tnlString boundaryConditionsType = parameters.getParameter< tnlString >( \"boundary-conditions-type\" );\n" )
    file.write( "          if( parameters.checkParameter( \"boundary-conditions-constant\" ) )\n" )
    file.write( "          {\n" )
    file.write( "             typedef ConstantFunction< Dimensions, Real > ConstantFunction;\n" )
    file.write( "             if( boundaryConditionsType == \"dirichlet\" )\n" )
    file.write( "             {\n" )
    file.write( "                typedef tnlDirichletBoundaryConditions< MeshType, ConstantFunction, MeshType::getMeshDimensions(), Real, Index > BoundaryConditions;\n" )
    file.write( "                typedef " + problemBaseName + "Problem< MeshType, BoundaryConditions, RightHandSide, ApproximateOperator > Problem;\n" )
    file.write( "                SolverStarter solverStarter;\n" )
    file.write( "                return solverStarter.template run< Problem >( parameters );\n" )
    file.write( "             }\n" )
    file.write( "             typedef tnlNeumannBoundaryConditions< MeshType, ConstantFunction, Real, Index > BoundaryConditions;\n" )
    file.write( "             typedef " + problemBaseName + "Problem< MeshType, BoundaryConditions, RightHandSide, ApproximateOperator > Problem;\n" )
    file.write( "             SolverStarter solverStarter;\n" )
    file.write( "             return solverStarter.template run< Problem >( parameters );\n" )
    file.write( "          }\n" )
    file.write( "          typedef tnlMeshFunction< MeshType > MeshFunction;\n" )
    file.write( "          if( boundaryConditionsType == \"dirichlet\" )\n" )
    file.write( "          {\n" )
    file.write( "             typedef tnlDirichletBoundaryConditions< MeshType, MeshFunction, MeshType::getMeshDimensions(), Real, Index > BoundaryConditions;\n" )
    file.write( "             typedef " + problemBaseName + "Problem< MeshType, BoundaryConditions, RightHandSide, ApproximateOperator > Problem;\n" )
    file.write( "             SolverStarter solverStarter;\n" )
    file.write( "             return solverStarter.template run< Problem >( parameters );\n" )
    file.write( "          }\n" )
    file.write( "          typedef tnlNeumannBoundaryConditions< MeshType, MeshFunction, Real, Index > BoundaryConditions;\n" )
    file.write( "          typedef " + problemBaseName + "Problem< MeshType, BoundaryConditions, RightHandSide, ApproximateOperator > Problem;\n" )
    file.write( "          SolverStarter solverStarter;\n" )
    file.write( "          return solverStarter.template run< Problem >( parameters );\n" )
    file.write( "      }\n" )
    file.write( "\n" )
    file.write( "};\n" )
    file.write( "\n" )
    file.write( "int main( int argc, char* argv[] )\n" )
    file.write( "{\n" )
    file.write( "   tnlSolver< " + problemBaseName + "Setter, " + problemBaseName + "Config, BuildConfig > solver;\n" )
    file.write( "   if( ! solver. run( argc, argv ) )\n" )
    file.write( "      return EXIT_FAILURE;\n" )
    file.write( "   return EXIT_SUCCESS;\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.close()
    file = open( problemBaseName + ".cpp", "w")
    file.write( "#include \"" + problemBaseName + ".h\"\n")
    file.close();
    file = open( problemBaseName + "-cuda.cu", "w")
    file.write( "#include \"" + problemBaseName + ".h\"\n")
    file.close()
    
def generateProblem( problemName, problemBaseName ):
    file = open( problemBaseName + "Problem.h", "w" )
    file.write( "#ifndef " + problemBaseName + "PROBLEM_H_\n" )
    file.write( "#define " + problemBaseName + "PROBLEM_H_\n" )
    file.write( "\n" )
    file.write( "#include <problems/tnlPDEProblem.h>\n")
    file.write( "#include <functions/tnlMeshFunction.h>\n")
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "           typename DifferentialOperator >\n" )
    file.write( "class " + problemBaseName + "Problem:\n" )
    file.write( "   public tnlPDEProblem< Mesh,\n" )
    file.write( "                         typename DifferentialOperator::RealType,\n" )
    file.write( "                         typename Mesh::DeviceType,\n" )
    file.write( "                         typename DifferentialOperator::IndexType >\n" )
    file.write( "{\n" )
    file.write( "   public:\n" )
    file.write( "\n" )
    file.write( "      typedef typename DifferentialOperator::RealType RealType;\n" )
    file.write( "      typedef typename Mesh::DeviceType DeviceType;\n" )
    file.write( "      typedef typename DifferentialOperator::IndexType IndexType;\n" )
    file.write( "      typedef tnlMeshFunction< Mesh > MeshFunctionType;\n" )
    file.write( "      typedef tnlPDEProblem< Mesh, RealType, DeviceType, IndexType > BaseType;\n" )
    file.write( "\n" )
    file.write( "      using typename BaseType::MeshType;\n" )
    file.write( "      using typename BaseType::DofVectorType;\n" )
    file.write( "      using typename BaseType::MeshDependentDataType;\n" )
    file.write( "\n" )
    file.write( "      static tnlString getTypeStatic();\n" )
    file.write( "\n" )
    file.write( "      tnlString getPrologHeader() const;\n" )
    file.write( "\n" )
    file.write( "      void writeProlog( tnlLogger& logger,\n" )
    file.write( "                        const tnlParameterContainer& parameters ) const;\n" )
    file.write( "\n" )
    file.write( "      bool setup( const tnlParameterContainer& parameters );\n" )
    file.write( "\n" )
    file.write( "      bool setInitialCondition( const tnlParameterContainer& parameters,\n" )
    file.write( "                                const MeshType& mesh,\n" )
    file.write( "                                DofVectorType& dofs,\n" )
    file.write( "                                MeshDependentDataType& meshDependentData );\n" )
    file.write( "\n" )
    file.write( "      template< typename Matrix >\n" )
    file.write( "      bool setupLinearSystem( const MeshType& mesh,\n" )
    file.write( "                              Matrix& matrix );\n" )
    file.write( "\n" )
    file.write( "      bool makeSnapshot( const RealType& time,\n" )
    file.write( "                         const IndexType& step,\n" )
    file.write( "                         const MeshType& mesh,\n" )
    file.write( "                         DofVectorType& dofs,\n" )
    file.write( "                         MeshDependentDataType& meshDependentData );\n" )
    file.write( "\n" )
    file.write( "      IndexType getDofs( const MeshType& mesh ) const;\n" )
    file.write( "\n" )
    file.write( "      void bindDofs( const MeshType& mesh,\n" )
    file.write( "                     DofVectorType& dofs );\n" )
    file.write( "\n" )
    file.write( "      void getExplicitRHS( const RealType& time,\n" )
    file.write( "                           const RealType& tau,\n" )
    file.write( "                           const MeshType& mesh,\n" )
    file.write( "                           DofVectorType& _u,\n" )
    file.write( "                           DofVectorType& _fu,\n" )
    file.write( "                           MeshDependentDataType& meshDependentData );\n" )
    file.write( "\n" )
    file.write( "      template< typename Matrix >\n" )
    file.write( "      void assemblyLinearSystem( const RealType& time,\n" )
    file.write( "                                 const RealType& tau,\n" )
    file.write( "                                 const MeshType& mesh,\n" )
    file.write( "                                 DofVectorType& dofs,\n" )
    file.write( "                                 Matrix& matrix,\n" )
    file.write( "                                 DofVectorType& rightHandSide,\n" )
    file.write( "                                 MeshDependentDataType& meshDependentData );\n" )
    file.write( "\n" )
    file.write( "   protected:\n" )
    file.write( "\n" )    
    file.write( "      DifferentialOperator differentialOperator;\n" )
    file.write( "      BoundaryCondition boundaryCondition;\n" )
    file.write( "      RightHandSide rightHandSide;\n" )
    file.write( "};\n" )
    file.write( "\n" )
    file.write( "#include \"" + problemBaseName + "Problem_impl.h\"\n" )
    file.write( "\n" )
    file.write( "#endif /* " + problemBaseName + "PROBLEM_H_ */\n" )
    file.close()
                                 
    file = open( problemBaseName + "Problem_impl.h", "w" )
    file.write( "#ifndef " + problemBaseName + "PROBLEM_IMPL_H_\n" )
    file.write( "#define " + problemBaseName + "PROBLEM_IMPL_H_\n" )
    file.write( "\n" )
    file.write( "#include <core/mfilename.h>\n" )
    file.write( "#include <matrices/tnlMatrixSetter.h>\n" )
    file.write( "#include <solvers/pde/tnlExplicitUpdater.h>\n" )
    file.write( "#include <solvers/pde/tnlLinearSystemAssembler.h>\n" )
    file.write( "#include <solvers/pde/tnlBackwardTimeDiscretisation.h>\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "tnlString\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )
    file.write( "getTypeStatic()\n" )
    file.write( "{\n" )
    file.write( "   return tnlString( \"" + problemBaseName + "Problem< \" ) + Mesh :: getTypeStatic() + \" >\";\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "tnlString\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )
    file.write( "getPrologHeader() const\n" )
    file.write( "{\n" )    
    file.write( "   return tnlString( \"" + problemName + "\" );\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "void\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )    
    file.write( "writeProlog( tnlLogger& logger, const tnlParameterContainer& parameters ) const\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * Add data you want to have in the computation report (log) as follows:\n" )
    file.write( "    * logger.writeParameter< double >( \"Parameter description\", parameter );\n" )
    file.write( "    */\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "bool\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )        
    file.write( "setup( const tnlParameterContainer& parameters )\n" )
    file.write( "{\n" )
    file.write( "   if( ! this->boundaryCondition.setup( parameters, \"boundary-conditions-\" ) ||\n" )
    file.write( "       ! this->rightHandSide.setup( parameters, \"right-hand-side-\" ) )\n" )
    file.write( "      return false;\n" )
    file.write( "   return true;\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "typename " + problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::IndexType\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )            
    file.write( "getDofs( const MeshType& mesh ) const\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * Return number of  DOFs (degrees of freedom) i.e. number\n" )
    file.write( "    * of unknowns to be resolved by the main solver.\n" )
    file.write( "    */\n" )
    file.write( "   return mesh.template getEntitiesCount< typename MeshType::Cell >();\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "void\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )            
    file.write( "bindDofs( const MeshType& mesh,\n" )
    file.write( "          DofVectorType& dofVector )\n" )    
    file.write( "{\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "bool\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )            
    file.write( "setInitialCondition( const tnlParameterContainer& parameters,\n" )    
    file.write( "                     const MeshType& mesh,\n" )
    file.write( "                     DofVectorType& dofs,\n" )
    file.write( "                     MeshDependentDataType& meshDependentData )\n" )
    file.write( "{\n" )
    file.write( "   const tnlString& initialConditionFile = parameters.getParameter< tnlString >( \"initial-condition\" );\n" )
    file.write( "   tnlMeshFunction< Mesh > u( mesh, dofs );\n" )
    file.write( "   if( ! u.boundLoad( initialConditionFile ) )\n" )
    file.write( "   {\n" )
    file.write( "      cerr << \"I am not able to load the initial condition from the file \" << initialConditionFile << \".\" << endl;\n" )
    file.write( "      return false;\n" )
    file.write( "   }\n" )
    file.write( "   return true; \n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "   template< typename Matrix >\n" )
    file.write( "bool\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )                
    file.write( "setupLinearSystem( const MeshType& mesh,\n" )
    file.write( "                   Matrix& matrix )\n" )
    file.write( "{\n" )
    file.write( "   const IndexType dofs = this->getDofs( mesh );\n" )
    file.write( "   typedef typename Matrix::CompressedRowsLengthsVector CompressedRowsLengthsVectorType;\n" )
    file.write( "   CompressedRowsLengthsVectorType rowLengths;\n" )
    file.write( "   if( ! rowLengths.setSize( dofs ) )\n" )
    file.write( "      return false;\n" )
    file.write( "   tnlMatrixSetter< MeshType, DifferentialOperator, BoundaryCondition, CompressedRowsLengthsVectorType > matrixSetter;\n" )
    file.write( "   matrixSetter.template getCompressedRowsLengths< typename Mesh::Cell >( mesh,\n" )
    file.write( "                                                                          differentialOperator,\n" )
    file.write( "                                                                          boundaryCondition,\n" )
    file.write( "                                                                          rowLengths );\n" )
    file.write( "   matrix.setDimensions( dofs, dofs );\n" )
    file.write( "   if( ! matrix.setCompressedRowsLengths( rowLengths ) )\n" )
    file.write( "      return false;\n" )
    file.write( "   return true;\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "bool\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )                    
    file.write( "makeSnapshot( const RealType& time,\n" )
    file.write( "              const IndexType& step,\n" )
    file.write( "              const MeshType& mesh,\n" )
    file.write( "              DofVectorType& dofs,\n" )
    file.write( "              MeshDependentDataType& meshDependentData )\n" )
    file.write( "{\n" )
    file.write( "   cout << endl << \"Writing output at time \" << time << \" step \" << step << \".\" << endl;\n" )
    file.write( "   this->bindDofs( mesh, dofs );\n" )
    file.write( "   tnlString fileName;\n" )
    file.write( "   FileNameBaseNumberEnding( \"u-\", step, 5, \".tnl\", fileName );\n" )
    file.write( "   if( ! dofs.save( fileName ) )\n" )
    file.write( "      return false;\n" )
    file.write( "   return true;\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "void\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )                    
    file.write( "getExplicitRHS( const RealType& time,\n" )
    file.write( "                const RealType& tau,\n" )
    file.write( "                const MeshType& mesh,\n" )
    file.write( "                DofVectorType& _u,\n" )
    file.write( "                DofVectorType& _fu,\n" )
    file.write( "                MeshDependentDataType& meshDependentData )\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * If you use an explicit solver like tnlEulerSolver or tnlMersonSolver, you\n" )
    file.write( "    * need to implement this method. Compute the right-hand side of\n" )
    file.write( "    *\n" )
    file.write( "    *   d/dt u(x) = fu( x, u )\n" )
    file.write( "    *\n" )
    file.write( "    * You may use supporting mesh dependent data if you need.\n" )
    file.write( "    */\n" )
    file.write( "\n" )
    file.write( "   this->bindDofs( mesh, _u );\n" )
    file.write( "   tnlExplicitUpdater< Mesh, MeshFunctionType, DifferentialOperator, BoundaryCondition, RightHandSide > explicitUpdater;\n" )
    file.write( "   MeshFunctionType u( mesh, _u ); \n" )
    file.write( "   MeshFunctionType fu( mesh, _fu ); \n" )
    file.write( "   explicitUpdater.template update< typename Mesh::Cell >( time,\n" )
    file.write( "                                                           mesh,\n" )
    file.write( "                                                           this->differentialOperator,\n" )
    file.write( "                                                           this->boundaryCondition,\n" )
    file.write( "                                                           this->rightHandSide,\n" )
    file.write( "                                                           u,\n" )
    file.write( "                                                           fu );\n" )
    file.write( "   tnlBoundaryConditionsSetter< MeshFunctionType, BoundaryCondition > boundaryConditionsSetter; \n" )
    file.write( "   boundaryConditionsSetter.template apply< typename Mesh::Cell >( \n" )
    file.write( "      this->boundaryCondition, \n" )
    file.write( "      time + tau, \n " )
    file.write( "      u ); \n " )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename BoundaryCondition,\n" )
    file.write( "          typename RightHandSide,\n" )
    file.write( "          typename DifferentialOperator >\n" )
    file.write( "   template< typename Matrix >\n" )
    file.write( "void\n" )
    file.write( problemBaseName + "Problem< Mesh, BoundaryCondition, RightHandSide, DifferentialOperator >::\n" )                
    file.write( "assemblyLinearSystem( const RealType& time,\n" )
    file.write( "                      const RealType& tau,\n" )
    file.write( "                      const MeshType& mesh,\n" )
    file.write( "                      DofVectorType& _u,\n" )
    file.write( "                      Matrix& matrix,\n" )
    file.write( "                      DofVectorType& b,\n" )
    file.write( "                      MeshDependentDataType& meshDependentData )\n" )
    file.write( "{\n" )
    file.write( "   tnlLinearSystemAssembler< Mesh,\n" )
    file.write( "                             MeshFunctionType,\n" )
    file.write( "                             DifferentialOperator,\n" )
    file.write( "                             BoundaryCondition,\n" )
    file.write( "                             RightHandSide,\n" )
    file.write( "                             tnlBackwardTimeDiscretisation,\n" )
    file.write( "                             Matrix,\n" )
    file.write( "                             DofVectorType > systemAssembler;\n" )
    file.write( "\n" )
    file.write( "   tnlMeshFunction< Mesh > u( mesh, _u );\n" )
    file.write( "   systemAssembler.template assembly< typename Mesh::Cell >( time,\n" )
    file.write( "                                                             tau,\n" )
    file.write( "                                                             mesh,\n" )
    file.write( "                                                             this->differentialOperator,\n" )
    file.write( "                                                             this->boundaryCondition,\n" )
    file.write( "                                                             this->rightHandSide,\n" )
    file.write( "                                                             u,\n" )
    file.write( "                                                             matrix,\n" )
    file.write( "                                                             b );\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "#endif /* " + problemBaseName + "PROBLEM_IMPL_H_ */\n" )
    file.close()

def generateOperatorGridSpecializationHeader( file, operatorName, dimensions ):
    file.write( "template< typename MeshReal,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename MeshIndex,\n" )
    file.write( "          typename Real,\n" )
    file.write( "          typename Index >\n" )
    file.write( "class " + operatorName + "< tnlGrid< " + dimensions + ",MeshReal, Device, MeshIndex >, Real, Index >\n" )
    file.write( "{\n" )
    file.write( "   public:\n" )
    file.write( "      typedef tnlGrid< " + dimensions + ", MeshReal, Device, MeshIndex > MeshType;\n" )
    file.write( "      typedef typename MeshType::CoordinatesType CoordinatesType;\n" )
    file.write( "      typedef Real RealType;\n" )
    file.write( "      typedef Device DeviceType;\n" )
    file.write( "      typedef Index IndexType;\n" )
    file.write( "      typedef tnlMeshFunction< MeshType > MeshFunctionType;\n" )
    file.write( "      enum { Dimensions = MeshType::getMeshDimensions() };\n" )
    file.write( "\n" )
    file.write( "      static tnlString getType();\n" )
    file.write( "\n" )
    file.write( "      template< typename MeshFunction, typename MeshEntity >\n" )
    file.write( "      __cuda_callable__\n" )
    file.write( "      Real operator()( const MeshFunction& u,\n" )
    file.write( "                       const MeshEntity& entity,\n" )
    file.write( "                       const RealType& time = 0.0 ) const;\n" )
    file.write( "\n" )
    file.write( "      __cuda_callable__\n" )
    file.write( "      template< typename MeshEntity >\n" )    
    file.write( "      Index getLinearSystemRowLength( const MeshType& mesh,\n" )
    file.write( "                                      const IndexType& index,\n" )
    file.write( "                                      const MeshEntity& entity ) const;\n" )
    file.write( "\n" )
    file.write( "      template< typename MeshEntity, typename Vector, typename MatrixRow >\n" )
    file.write( "      __cuda_callable__\n" )
    file.write( "      void updateLinearSystem( const RealType& time,\n" )
    file.write( "                               const RealType& tau,\n" )
    file.write( "                               const MeshType& mesh,\n" )
    file.write( "                               const IndexType& index,\n" )
    file.write( "                               const MeshEntity& entity,\n" )
    file.write( "                               const MeshFunctionType& u,\n" )
    file.write( "                               Vector& b,\n" )
    file.write( "                               MatrixRow& matrixRow ) const;\n" )
    file.write( "};\n" )
    file.write( "\n" )    
    
def generateOperatorGridSpecializationImplementation( file, operatorName, dimensions ):
    file.write( "template< typename MeshReal,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename MeshIndex,\n" )
    file.write( "          typename Real,\n" )
    file.write( "          typename Index >\n" )
    file.write( "tnlString\n" )
    file.write( operatorName + "< tnlGrid< " + dimensions + ", MeshReal, Device, MeshIndex >, Real, Index >::\n" )
    file.write( "getType()\n" )
    file.write( "{\n" )
    file.write( "   return tnlString( \"" + operatorName + "< \" ) +\n" )
    file.write( "          MeshType::getType() + \", \" +\n" )
    file.write( "          ::getType< Real >() + \", \" +\n" )
    file.write( "          ::getType< Index >() + \" >\";\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename MeshReal,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename MeshIndex,\n" )
    file.write( "          typename Real,\n" )
    file.write( "          typename Index >\n" )    
    file.write( "template< typename MeshFunction, typename MeshEntity >\n" )
    file.write( "__cuda_callable__\n" )
    file.write( "Real\n" )
    file.write( operatorName + "< tnlGrid< " + dimensions + ", MeshReal, Device, MeshIndex >, Real, Index >::\n" )
    file.write( "operator()( const MeshFunction& u,\n" )
    file.write( "            const MeshEntity& entity,\n" )
    file.write( "            const Real& time ) const\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * Implement your explicit form of the differential operator here.\n" )
    file.write( "    * The following example is the Laplace operator approximated \n" )
    file.write( "    * by the Finite difference method.\n" )
    file.write( "    */\n" )  
    file.write( '    static_assert( MeshEntity::entityDimensions == ' + dimensions + ', "Wrong mesh entity dimensions." ); \n' )
    file.write( '    static_assert( MeshFunction::getEntitiesDimensions() == ' + dimensions + ', "Wrong preimage function" ); \n' )
    file.write( "    const typename MeshEntity::template NeighbourEntities< " + dimensions + " >& neighbourEntities = entity.getNeighbourEntities(); \n" )
    file.write( "\n" )
    if dimensions == "1":
        file.write( "   const RealType& hxSquareInverse = entity.getMesh().template getSpaceStepsProducts< -2 >(); \n" )
        file.write( "   const IndexType& center = entity.getIndex(); \n" )
        file.write( "   const IndexType& east = neighbourEntities.template getEntityIndex< 1 >(); \n" )
        file.write( "   const IndexType& west = neighbourEntities.template getEntityIndex< -1 >(); \n" )
        file.write( "   return ( u[ west ] - 2.0 * u[ center ]  + u[ east ] ) * hxSquareInverse;\n" )
    if dimensions == "2":
        file.write( "   const RealType& hxSquareInverse = entity.getMesh().template getSpaceStepsProducts< -2, 0 >(); \n" )
        file.write( "   const RealType& hySquareInverse = entity.getMesh().template getSpaceStepsProducts< 0, -2 >(); \n" )
        file.write( "   const IndexType& center = entity.getIndex(); \n" )
        file.write( "   const IndexType& east  = neighbourEntities.template getEntityIndex<  1,  0 >(); \n" )
        file.write( "   const IndexType& west  = neighbourEntities.template getEntityIndex< -1,  0 >(); \n" )
        file.write( "   const IndexType& north = neighbourEntities.template getEntityIndex<  0,  1 >(); \n" )
        file.write( "   const IndexType& south = neighbourEntities.template getEntityIndex<  0, -1 >(); \n" )        
        file.write( "   return ( u[ west ] - 2.0 * u[ center ] + u[ east ]  ) * hxSquareInverse +\n" )
        file.write( "          ( u[ south ] - 2.0 * u[ center ] + u[ north ] ) * hySquareInverse;\n" )
    if dimensions == "3":
        file.write( "   const RealType& hxSquareInverse = entity.getMesh().template getSpaceStepsProducts< -2,  0,  0 >(); \n" )
        file.write( "   const RealType& hySquareInverse = entity.getMesh().template getSpaceStepsProducts<  0, -2,  0 >(); \n" )
        file.write( "   const RealType& hzSquareInverse = entity.getMesh().template getSpaceStepsProducts<  0,  0, -2 >(); \n" )
        file.write( "   const IndexType& center = entity.getIndex(); \n" )
        file.write( "   const IndexType& east  = neighbourEntities.template getEntityIndex<  1,  0,  0 >(); \n" )
        file.write( "   const IndexType& west  = neighbourEntities.template getEntityIndex< -1,  0,  0 >(); \n" )
        file.write( "   const IndexType& north = neighbourEntities.template getEntityIndex<  0,  1,  0 >(); \n" )
        file.write( "   const IndexType& south = neighbourEntities.template getEntityIndex<  0, -1,  0 >(); \n" )        
        file.write( "   const IndexType& up    = neighbourEntities.template getEntityIndex<  0,  0,  1 >(); \n" )
        file.write( "   const IndexType& down  = neighbourEntities.template getEntityIndex<  0,  0, -1 >(); \n" )        
        file.write( "   return ( u[ west ] - 2.0 * u[ center ] + u[ east ]  ) * hxSquareInverse +\n" )
        file.write( "          ( u[ south ] - 2.0 * u[ center ] + u[ north ] ) * hySquareInverse +\n" )
        file.write( "          ( u[ up ] - 2.0 * u[ center ] + u[ down ] ) * hzSquareInverse;\n" )                
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename MeshReal,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename MeshIndex,\n" )
    file.write( "          typename Real,\n" )
    file.write( "          typename Index >\n" )        
    file.write( "template< typename MeshEntity >\n" )
    file.write( "__cuda_callable__\n" )
    file.write( "Index\n" )
    file.write( operatorName + "< tnlGrid< " + dimensions + ", MeshReal, Device, MeshIndex >, Real, Index >::\n" )
    file.write( "getLinearSystemRowLength( const MeshType& mesh,\n" )
    file.write( "                          const IndexType& index,\n" )
    file.write( "                          const MeshEntity& entity ) const\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * Return a number of non-zero elements in a line (associated with given grid element) of\n" )
    file.write( "    * the linear system.\n" )
    file.write( "    * The following example is the Laplace operator approximated \n" )
    file.write( "    * by the Finite difference method.\n" )
    file.write( "    */\n" )
    file.write( "\n" )
    file.write( "   return 2*Dimensions + 1;\n" )
    file.write( "}\n" )
    file.write( "\n" )
    file.write( "template< typename MeshReal,\n" )
    file.write( "          typename Device,\n" )
    file.write( "          typename MeshIndex,\n" )
    file.write( "          typename Real,\n" )
    file.write( "          typename Index >\n" )
    file.write( "   template< typename MeshEntity, typename Vector, typename MatrixRow >\n" )       
    file.write( "__cuda_callable__\n" )        
    file.write( "void\n" )
    file.write( operatorName + "< tnlGrid< " + dimensions + ", MeshReal, Device, MeshIndex >, Real, Index >::\n" )
    file.write( "updateLinearSystem( const RealType& time,\n" )
    file.write( "                    const RealType& tau,\n" )
    file.write( "                    const MeshType& mesh,\n" )
    file.write( "                    const IndexType& index,\n" )
    file.write( "                    const MeshEntity& entity,\n" )
    file.write( "                    const MeshFunctionType& u,\n" )
    file.write( "                    Vector& b,\n" )
    file.write( "                    MatrixRow& matrixRow ) const\n" )
    file.write( "{\n" )
    file.write( "   /****\n" )
    file.write( "    * Setup the non-zero elements of the linear system here.\n" )
    file.write( "    * The following example is the Laplace operator appriximated \n" )
    file.write( "    * by the Finite difference method.\n" )
    file.write( "    */\n" )    
    file.write( "\n" )
    file.write( "    const typename MeshEntity::template NeighbourEntities< " + dimensions + " >& neighbourEntities = entity.getNeighbourEntities(); \n" )
    if dimensions == "1":
       file.write( "   const RealType& lambdaX = tau * entity.getMesh().template getSpaceStepsProducts< -2 >(); \n" )
       file.write( "   const IndexType& center = entity.getIndex(); \n" )
       file.write( "   const IndexType& east = neighbourEntities.template getEntityIndex< 1 >(); \n" )
       file.write( "   const IndexType& west = neighbourEntities.template getEntityIndex< -1 >(); \n" )
       file.write( "   matrixRow.setElement( 0, west,   - lambdaX );\n" )
       file.write( "   matrixRow.setElement( 1, center, 2.0 * lambdaX );\n" )
       file.write( "   matrixRow.setElement( 2, east,   - lambdaX );\n" )
    if dimensions == "2":
        file.write( "   const RealType& lambdaX = tau * entity.getMesh().template getSpaceStepsProducts< -2, 0 >(); \n" )
        file.write( "   const RealType& lambdaY = tau * entity.getMesh().template getSpaceStepsProducts< 0, -2 >(); \n" )
        file.write( "   const IndexType& center = entity.getIndex(); \n" )
        file.write( "   const IndexType& east  = neighbourEntities.template getEntityIndex<  1,  0 >(); \n" )
        file.write( "   const IndexType& west  = neighbourEntities.template getEntityIndex< -1,  0 >(); \n" )
        file.write( "   const IndexType& north = neighbourEntities.template getEntityIndex<  0,  1 >(); \n" )
        file.write( "   const IndexType& south = neighbourEntities.template getEntityIndex<  0, -1 >(); \n" )        
        file.write( "   matrixRow.setElement( 0, south,  -lambdaY );\n" )
        file.write( "   matrixRow.setElement( 1, west,   -lambdaX );\n" )
        file.write( "   matrixRow.setElement( 2, center, 2.0 * ( lambdaX + lambdaY ) );\n" )
        file.write( "   matrixRow.setElement( 3, east,   -lambdaX );\n" )
        file.write( "   matrixRow.setElement( 4, north,  -lambdaY );\n" )
    if dimensions == "3":
        file.write( "   const RealType& lambdaX = tau * entity.getMesh().template getSpaceStepsProducts< -2,  0,  0 >(); \n" )
        file.write( "   const RealType& lambdaY = tau * entity.getMesh().template getSpaceStepsProducts<  0, -2,  0 >(); \n" )
        file.write( "   const RealType& lambdaZ = tau * entity.getMesh().template getSpaceStepsProducts<  0,  0, -2 >(); \n" )
        file.write( "   const IndexType& center = entity.getIndex(); \n" )
        file.write( "   const IndexType& east  = neighbourEntities.template getEntityIndex<  1,  0,  0 >(); \n" )
        file.write( "   const IndexType& west  = neighbourEntities.template getEntityIndex< -1,  0,  0 >(); \n" )
        file.write( "   const IndexType& north = neighbourEntities.template getEntityIndex<  0,  1,  0 >(); \n" )
        file.write( "   const IndexType& south = neighbourEntities.template getEntityIndex<  0, -1,  0 >(); \n" )        
        file.write( "   const IndexType& up    = neighbourEntities.template getEntityIndex<  0,  0,  1 >(); \n" )
        file.write( "   const IndexType& down  = neighbourEntities.template getEntityIndex<  0,  0, -1 >(); \n" )                
        file.write( "   matrixRow.setElement( 0, down,   -lambdaZ );\n" )
        file.write( "   matrixRow.setElement( 1, south,  -lambdaY );\n" )
        file.write( "   matrixRow.setElement( 2, west,   -lambdaX );\n" )
        file.write( "   matrixRow.setElement( 3, center, 2.0 * ( lambdaX + lambdaY + lambdaZ ) );\n" )
        file.write( "   matrixRow.setElement( 4, east,   -lambdaX );\n" )
        file.write( "   matrixRow.setElement( 5, north,  -lambdaY );\n" )
        file.write( "   matrixRow.setElement( 6, up,     -lambdaZ );\n" )
    file.write( "}\n" )
    file.write( "\n" )
    
def generateOperator( operatorName):
    file = open( operatorName + ".h", "w" )    
    file.write( "#ifndef " + operatorName + "_H\n" )
    file.write( "#define " + operatorName + "_H\n" )
    file.write( "\n" )
    file.write( "#include <core/vectors/tnlVector.h>\n" )
    file.write( "#include <mesh/tnlGrid.h>\n" )
    file.write( "\n" )
    file.write( "template< typename Mesh,\n" )
    file.write( "          typename Real = typename Mesh::RealType,\n" )
    file.write( "          typename Index = typename Mesh::IndexType >\n" )
    file.write( "class " + operatorName + "\n" )
    file.write( "{\n" )
    file.write( "};\n" )
    file.write( "\n" )
    generateOperatorGridSpecializationHeader( file, operatorName, "1" )
    generateOperatorGridSpecializationHeader( file, operatorName, "2" )
    generateOperatorGridSpecializationHeader( file, operatorName, "3" )
    file.write( "\n" )
    file.write( "#include \""+ operatorName + "_impl.h\"\n" )
    file.write( "\n" )
    file.write( "#endif	/* " + operatorName + "_H */\n" )
    file.close()
    file = open( operatorName + "_impl.h", "w" )    
    file.write( "#ifndef " + operatorName + "_IMPL_H\n" )
    file.write( "#define " + operatorName + "_IMPL_H\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * 1D problem\n" )
    file.write( " */\n" )
    generateOperatorGridSpecializationImplementation( file, operatorName, "1" )
    file.write( "/****\n" )
    file.write( " * 2D problem\n" )
    file.write( " */\n" )
    generateOperatorGridSpecializationImplementation( file, operatorName, "2" )
    file.write( "/****\n" )
    file.write( " * 3D problem\n" )
    file.write( " */\n" )    
    generateOperatorGridSpecializationImplementation( file, operatorName, "3" )
    file.write( "#endif	/* " + operatorName + "IMPL_H */\n" )
    file.write( "\n" )
    file.close()
    
def generateRhs( problemBaseName ):
    file = open( problemBaseName + "Rhs.h", "w" )
    file.write( "#ifndef " + problemBaseName + "RHS_H_\n" )
    file.write( "#define " + problemBaseName + "RHS_H_\n" )
    file.write( "#include<functions/tnlDomain.h>")
    file.write( "\n" )
    file.write( "template< typename Mesh, typename Real >" )
    file.write( "class " + problemBaseName + "Rhs\n" )
    file.write( "  : public tnlDomain< Mesh::meshDimensions, MeshDomain > \n " )
    file.write( "{\n" )
    file.write( "   public:\n" )
    file.write( "\n" )
    file.write( "      typedef Mesh MeshType;\n" )
    file.write( "      typedef Real RealType;\n" )
    file.write( "\n" )
    file.write( "      bool setup( const tnlParameterContainer& parameters,\n" )
    file.write( "                  const tnlString& prefix = \"\" )\n" )
    file.write( "      {\n" )
    file.write( "         return true;\n" )
    file.write( "      }\n" )
    file.write( "\n" )
    file.write( "      template< typename MeshEntity >\n" )   
    file.write( "      __cuda_callable__\n" )
    file.write( "      Real operator()( const MeshEntity& entity,\n" )
    file.write( "                       const Real& time = 0.0 ) const\n" )    
    file.write( "      {\n" )    
    file.write( "         typedef typename MeshEntity::MeshType::VertexType VertexType;\n" )
    file.write( "         VertexType v = entity.getCenter();\n" )        
    file.write( "         return 0.0;\n" )    
    file.write( "      };\n" )    
    file.write( "};\n" )    
    file.write( "\n" )    
    file.write( "#endif /* " + problemBaseName + "RHS_H_ */\n" )    
    file.close()

def generateBuildConfigTags( problemBaseName ):
    file = open( problemBaseName + "BuildConfigTag.h", "w" )
    file.write( "#ifndef " + problemBaseName + "BUILDCONFIGTAG_H_\n" )
    file.write( "#define " + problemBaseName + "BUILDCONFIGTAG_H_\n" )
    file.write( "\n" )
    file.write( "#include <solvers/tnlBuildConfigTags.h>\n" )
    file.write( "\n" )
    file.write( "class " + problemBaseName + "BuildConfigTag{};\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * Turn off support for float and long double.\n" )
    file.write( " */\n" )
    file.write( "template<> struct tnlConfigTagReal< " + problemBaseName + "BuildConfigTag, float > { enum { enabled = false }; };\n" )
    file.write( "template<> struct tnlConfigTagReal< " + problemBaseName + "BuildConfigTag, long double > { enum { enabled = false }; };\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * Turn off support for short int and long int indexing.\n" )
    file.write( " */\n" )
    file.write( "template<> struct tnlConfigTagIndex< " + problemBaseName + "BuildConfigTag, short int >{ enum { enabled = false }; };\n" )
    file.write( "template<> struct tnlConfigTagIndex< " + problemBaseName + "BuildConfigTag, long int >{ enum { enabled = false }; };\n" )
    file.write( "\n" )    
    file.write( "/****\n" )
    file.write( " * How many dimensions may have the problem to be solved...\n" )
    file.write( " */\n" )    
    file.write( "template< int Dimensions > struct tnlConfigTagDimensions< " + problemName + "BuildConfigTag, Dimensions >{ enum { enabled = ( Dimensions == 1 ) }; };\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * Use of tnlGrid is enabled for allowed dimensions and Real, Device and Index types.\n" )
    file.write( " */\n" )
    file.write( "template< int Dimensions, typename Real, typename Device, typename Index >\n" )
    file.write( "   struct tnlConfigTagMesh< " + problemBaseName + "BuildConfigTag, tnlGrid< Dimensions, Real, Device, Index > >\n" )
    file.write( "      { enum { enabled = tnlConfigTagDimensions< " + problemBaseName + "BuildConfigTag, Dimensions >::enabled  &&\n" )
    file.write( "                         tnlConfigTagReal< " + problemBaseName + "BuildConfigTag, Real >::enabled &&\n" )
    file.write( "                         tnlConfigTagDevice< " + problemBaseName + "BuildConfigTag, Device >::enabled &&\n" )
    file.write( "                         tnlConfigTagIndex< " + problemBaseName + "BuildConfigTag, Index >::enabled }; };\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * Please, chose your preferred time discretisation  here.\n" )
    file.write( " */\n" )
    file.write( "template<> struct tnlConfigTagTimeDiscretisation< " + problemBaseName + "BuildConfigTag, tnlExplicitTimeDiscretisationTag >{ enum { enabled = true }; };\n" )
    file.write( "template<> struct tnlConfigTagTimeDiscretisation< " + problemBaseName + "BuildConfigTag, tnlSemiImplicitTimeDiscretisationTag >{ enum { enabled = true }; };\n" )
    file.write( "template<> struct tnlConfigTagTimeDiscretisation< " + problemBaseName + "BuildConfigTag, tnlImplicitTimeDiscretisationTag >{ enum { enabled = false }; };\n" )
    file.write( "\n" )
    file.write( "/****\n" )
    file.write( " * Only the Runge-Kutta-Merson solver is enabled by default.\n" )
    file.write( " */\n" )
    file.write( "template<> struct tnlConfigTagExplicitSolver< " + problemBaseName + "BuildConfigTag, tnlExplicitEulerSolverTag >{ enum { enabled = false }; };\n" )
    file.write( "\n" )        
    file.write( "#endif /* " + problemBaseName + "BUILDCONFIGTAG_H_ */\n" )        
    file.close()
    

def generateRunScript( problemBaseName ):
    file = open( "run-" + problemBaseName, "w" )
    file.write( "#!/usr/bin/env bash\n" ) 
    file.write( "\n" ) 
    file.write( "tnl-grid-setup --dimensions 2 \\\n" ) 
    file.write( "               --origin-x 0.0 \\\n" ) 
    file.write( "               --origin-y 0.0 \\\n" ) 
    file.write( "               --proportions-x 1.0 \\\n" ) 
    file.write( "               --proportions-y 1.0 \\\n" ) 
    file.write( "               --size-x 100 \\\n" ) 
    file.write( "               --size-y 100\n" ) 
    file.write( "\n" ) 
    file.write( "tnl-init --test-function sin-wave \\\n" ) 
    file.write( "         --output-file init.tnl\n" ) 
    file.write( "./" + problemBaseName + " --time-discretisation explicit \\\n" ) 
    file.write( "              --boundary-conditions-constant 0 \\\n" )
    file.write( "              --discrete-solver merson \\\n" ) 
    file.write( "              --snapshot-period 0.01 \\\n" ) 
    file.write( "              --final-time 1.0\n" ) 
    file.write( "\n" ) 
    file.write( "tnl-view --mesh mesh.tnl --input-files *tnl     \n" ) 
    file.close()
    
print( "TNL Quickstart -- solver generator")
print( "----------------------------------")
problemName = input( "Problam name:" )
problemBaseName = input( "Problem class base name (base name acceptable in C++ code):" )
operatorName = input( "Operator name:")
generateMakefile( problemBaseName )
generateMain( problemName, problemBaseName, operatorName )
generateProblem( problemName, problemBaseName )
generateOperator( operatorName )
generateRhs( problemBaseName )
generateBuildConfigTags( problemBaseName )
generateRunScript( problemBaseName )