/***************************************************************************
                          SolverConfig_impl.h  -  description
                             -------------------
    begin                : Jul 8, 2014
    copyright            : (C) 2014 by Tomas Oberhuber
    email                : tomas.oberhuber@fjfi.cvut.cz
 ***************************************************************************/

/* See Copyright Notice in tnl/Copyright */

#pragma once

#include <TNL/tnlConfig.h>
#include <TNL/Solvers/BuildConfigTags.h>
#include <TNL/Solvers/DummyProblem.h>
#include <TNL/Solvers/PDE/ExplicitTimeStepper.h>
#include <TNL/Solvers/PDE/TimeDependentPDESolver.h>

namespace TNL {
namespace Solvers {

template< typename ConfigTag,
          typename ProblemConfig >
bool SolverConfig< ConfigTag, ProblemConfig >::configSetup( Config::ConfigDescription& config )
{
   typedef DummyProblem< double, Devices::Host, int > DummyProblemType;

   config.addDelimiter( " === General parameters ==== " );
   config.addEntry< bool >( "catch-exceptions",
                            "Catch C++ exceptions. Disabling it allows the program to drop into the debugger "
                            "and track the origin of the exception.",
                            true );
   /****
    * Setup real type
    */
   config.addEntry< String >( "real-type",
                                 "Precision of the floating point arithmetics.",
                                 "double" );
   if( ConfigTagReal< ConfigTag, float >::enabled )
      config.addEntryEnum( "float" );
   if( ConfigTagReal< ConfigTag, double >::enabled )
      config.addEntryEnum( "double" );
   if( ConfigTagReal< ConfigTag, long double >::enabled )
      config.addEntryEnum( "long-double" );

   /****
    * Setup device.
    */
   config.addEntry< String >( "device",
                                 "Device to use for the computations.",
                                 "host" );
   if( ConfigTagDevice< ConfigTag, Devices::Host >::enabled )
      config.addEntryEnum( "host" );
#ifdef HAVE_CUDA
   if( ConfigTagDevice< ConfigTag, Devices::Cuda >::enabled )
      config.addEntryEnum( "cuda" );
#endif
   
#ifdef HAVE_MIC
   if( ConfigTagDevice< ConfigTag, Devices::MIC >::enabled )
      config.addEntryEnum( "mic" );
#endif
   

   /****
    * Setup index type.
    */
   config.addEntry< String >( "index-type",
                                 "Indexing type for arrays, vectors, matrices etc.",
                                 "int" );
   if( ConfigTagIndex< ConfigTag, short int >::enabled )
      config.addEntryEnum( "short-int" );

   if( ConfigTagIndex< ConfigTag, int >::enabled )
      config.addEntryEnum( "int" );

   if( ConfigTagIndex< ConfigTag, long int >::enabled )
      config.addEntryEnum( "long-int" );

   /****
    * Mesh file parameter
    */
   config.addDelimiter( " === Space discretisation parameters ==== " );
   config.addEntry< String >( "mesh", "A file which contains the numerical mesh. You may create it with tools like tnl-grid-setup or tnl-mesh-convert.", "mesh.tnl" );


   /****
    * Time discretisation
    */
   config.addDelimiter( " === Time discretisation parameters ==== " );
   typedef PDE::ExplicitTimeStepper< DummyProblemType, ODE::Euler > ExplicitTimeStepper;
   PDE::TimeDependentPDESolver< DummyProblemType, ExplicitTimeStepper >::configSetup( config );
   ExplicitTimeStepper::configSetup( config );
   if( ConfigTagTimeDiscretisation< ConfigTag, ExplicitTimeDiscretisationTag >::enabled ||
       ConfigTagTimeDiscretisation< ConfigTag, SemiImplicitTimeDiscretisationTag >::enabled ||
       ConfigTagTimeDiscretisation< ConfigTag, ImplicitTimeDiscretisationTag >::enabled )
   {
      config.addRequiredEntry< String >( "time-discretisation", "Discratisation in time.");
      if( ConfigTagTimeDiscretisation< ConfigTag, ExplicitTimeDiscretisationTag >::enabled )
         config.addEntryEnum( "explicit" );
      if( ConfigTagTimeDiscretisation< ConfigTag, SemiImplicitTimeDiscretisationTag >::enabled )
         config.addEntryEnum( "semi-implicit" );
      if( ConfigTagTimeDiscretisation< ConfigTag, ImplicitTimeDiscretisationTag >::enabled )
         config.addEntryEnum( "implicit" );
   }
   config.addRequiredEntry< String >( "discrete-solver", "The solver of the discretised problem:" );
   if( ConfigTagTimeDiscretisation< ConfigTag, ExplicitTimeDiscretisationTag >::enabled )
   {
      if( ConfigTagExplicitSolver< ConfigTag, ExplicitEulerSolverTag >::enabled )
         config.addEntryEnum( "euler" );
      if( ConfigTagExplicitSolver< ConfigTag, ExplicitMersonSolverTag >::enabled )
         config.addEntryEnum( "merson" );
   }
   if( ConfigTagTimeDiscretisation< ConfigTag, SemiImplicitTimeDiscretisationTag >::enabled )
   {
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitCGSolverTag >::enabled )
         config.addEntryEnum( "cg" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitBICGStabSolverTag >::enabled )
         config.addEntryEnum( "bicgstab" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitBICGStabLSolverTag >::enabled )
         config.addEntryEnum( "bicgstabl" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitCWYGMRESSolverTag >::enabled )
         config.addEntryEnum( "cwygmres" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitGMRESSolverTag >::enabled )
         config.addEntryEnum( "gmres" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitTFQMRSolverTag >::enabled )
         config.addEntryEnum( "tfqmr" );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitSORSolverTag >::enabled )
         config.addEntryEnum( "sor" );
#ifdef HAVE_UMFPACK
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitUmfpackSolverTag >::enabled )
         config.addEntryEnum( "umfpack" );
#endif
   }
   config.addEntry< String >( "preconditioner", "The preconditioner for the discrete solver:", "none" );
   config.addEntryEnum( "none" );
   config.addEntryEnum( "diagonal" );
// TODO: implement parallel ILU or device-dependent build config tags for preconditioners
#ifndef HAVE_CUDA
   config.addEntryEnum( "ilu0" );
#endif
   if( ConfigTagTimeDiscretisation< ConfigTag, ExplicitTimeDiscretisationTag >::enabled ||
       ConfigTagTimeDiscretisation< ConfigTag, SemiImplicitTimeDiscretisationTag >::enabled )
   {
      config.addDelimiter( " === Iterative solvers parameters === " );
      IterativeSolver< double, int >::configSetup( config );
   }
   if( ConfigTagTimeDiscretisation< ConfigTag, ExplicitTimeDiscretisationTag >::enabled )
   {
      config.addDelimiter( " === Explicit solvers parameters === " );
      ODE::ExplicitSolver< DummyProblem< double, Devices::Host, int > >::configSetup( config );
      if( ConfigTagExplicitSolver< ConfigTag, ExplicitEulerSolverTag >::enabled )
         ODE::Euler< DummyProblem< double, Devices::Host, int > >::configSetup( config );

      if( ConfigTagExplicitSolver< ConfigTag, ExplicitMersonSolverTag >::enabled )
         ODE::Merson< DummyProblem< double, Devices::Host, int > >::configSetup( config );
   }
   if( ConfigTagTimeDiscretisation< ConfigTag, SemiImplicitTimeDiscretisationTag >::enabled )
   {
      config.addDelimiter( " === Semi-implicit solvers parameters === " );
      typedef Matrices::CSR< double, Devices::Host, int > MatrixType;
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitCGSolverTag >::enabled )
         Linear::CG< MatrixType >::configSetup( config );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitBICGStabSolverTag >::enabled )
         Linear::BICGStab< MatrixType >::configSetup( config );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitBICGStabLSolverTag >::enabled )
         Linear::BICGStabL< MatrixType >::configSetup( config );

      // GMRES and CWYGMRES have the same options
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitCWYGMRESSolverTag >::enabled )
         Linear::CWYGMRES< MatrixType >::configSetup( config );
      else if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitGMRESSolverTag >::enabled )
         Linear::GMRES< MatrixType >::configSetup( config );

      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitTFQMRSolverTag >::enabled )
         Linear::TFQMR< MatrixType >::configSetup( config );
      if( ConfigTagSemiImplicitSolver< ConfigTag, SemiImplicitSORSolverTag >::enabled )
         Linear::SOR< MatrixType >::configSetup( config );
   }

   config.addDelimiter( " === Logs and messages ===" );
   config.addEntry< int >( "verbose", "Set the verbose mode. The higher number the more messages are generated.", 1 );
   config.addEntry< String >( "log-file", "Log file for the computation.", "log.txt" );
   config.addEntry< int >( "log-width", "Number of columns of the log table.", 80 );
   return true;

}

} // namespace Solvers
} // namespace TNL
