/***************************************************************************
                          ConfigEntryType.h  -  description
                             -------------------
    begin                : Jul 5, 2014
    copyright            : (C) 2014 by Tomas Oberhuber
    email                : tomas.oberhuber@fjfi.cvut.cz
 ***************************************************************************/

/* See Copyright Notice in tnl/Copyright */

#pragma once

#include <vector>

#include <TNL/String.h>

namespace TNL {
namespace Config {

template< typename EntryType >
inline String getUIEntryType() { return "Unknown type."; };

template<> inline String getUIEntryType< String >() { return "string"; };
template<> inline String getUIEntryType< bool >()   { return "bool"; };
template<> inline String getUIEntryType< int >()    { return "integer"; };
template<> inline String getUIEntryType< double >() { return "real"; };

template<> inline String getUIEntryType< std::vector< String > >() { return "list of string"; };
template<> inline String getUIEntryType< std::vector< bool > >()   { return "list of bool"; };
template<> inline String getUIEntryType< std::vector< int > >()    { return "list of integer"; };
template<> inline String getUIEntryType< std::vector< double > >() { return "list of real"; };

struct ConfigEntryType
{
   String basic_type;

   bool list_entry;

   ConfigEntryType() = default;

   ConfigEntryType( const String& _basic_type,
                    const bool _list_entry )
   : basic_type( _basic_type ),
     list_entry( _list_entry )
   {}

   void Reset()
   {
      basic_type.clear();
      list_entry = false;
   }
};

} // namespace Config
} // namespace TNL
