#if !defined(_MESH_ENTITY_H_)
#define _MESH_ENTITY_H_

#include <mesh/topology/vertex.h>
#include <mesh/detail/mesh_entity_border.h>
#include <mesh/detail/mesh_entity_coborder.h>
#include <mesh/detail/mesh_pointer.h>
#include <mesh/detail/id.h>
#include <mesh/detail/point.h>


namespace implementation
{


template<typename, typename> class EntityInitializer;

template<typename> class IOReader;
template<typename> class IOWriter;


template<typename MeshConfigTag, typename MeshEntityTag>
class MeshEntity : public MeshPointerProvider<MeshConfigTag>,
                   public MeshEntityBorder<MeshConfigTag, MeshEntityTag>,
                   public MeshEntityCoborder<MeshConfigTag, MeshEntityTag>,
                   public IDProvider<typename MeshConfigTag::IDType, typename MeshConfigTag::GlobalIndexType>
{
	friend class MeshEntityKey<MeshConfigTag, MeshEntityTag>;
	friend class EntityInitializer<MeshConfigTag, MeshEntityTag>;
	friend class IOReader<MeshConfigTag>;
	friend class IOWriter<MeshConfigTag>;

	typedef MeshEntityBorder<MeshConfigTag, MeshEntityTag>   BorderBaseType;
	typedef MeshEntityCoborder<MeshConfigTag, MeshEntityTag> CoborderBaseType;

	typedef EntityBorderTag<MeshConfigTag, MeshEntityTag, DimTag<0> > BorderTag;
	typedef typename BorderTag::ContainerType::DataType  GlobalIndexType;
	typedef typename BorderTag::ContainerType::IndexType LocalIndexType;

	enum { borderVerticesCount = BorderTag::count };

	template<DimensionType dim>
	struct BorderRangesTag
	{
		typedef typename EntityBorderTag<MeshConfigTag, MeshEntityTag, DimTag<dim> >::RangeType      RangeType;
		typedef typename EntityBorderTag<MeshConfigTag, MeshEntityTag, DimTag<dim> >::ConstRangeType ConstRangeType;
	};

	template<DimensionType dim>
	struct CoborderRangesTag
	{
		typedef typename EntityCoborderTag<MeshConfigTag, MeshEntityTag, DimTag<dim> >::RangeType      RangeType;
		typedef typename EntityCoborderTag<MeshConfigTag, MeshEntityTag, DimTag<dim> >::ConstRangeType ConstRangeType;
	};

public:
	typedef MeshConfigTag MeshConfig;
	typedef MeshEntityTag Tag;

	enum { dimension = Tag::dimension };
	enum { meshDimension = MeshTag<MeshConfigTag>::dimension };

	template<DimensionType dim> typename BorderRangesTag<dim>::RangeType      borderEntities()           { return this->borderRange(DimTag<dim>(), this->getMesh()); }
	template<DimensionType dim> typename BorderRangesTag<dim>::ConstRangeType borderEntities() const     { return this->borderRange(DimTag<dim>(), this->getMesh()); }

	template<DimensionType dim> typename CoborderRangesTag<dim>::RangeType      coborderEntities()       { return this->coborderRange(DimTag<dim>(), this->getMesh()); }
	template<DimensionType dim> typename CoborderRangesTag<dim>::ConstRangeType coborderEntities() const { return this->coborderRange(DimTag<dim>(), this->getMesh()); }

	size_t allocatedMemorySize() const { return BorderBaseType::allocatedMemorySize() + CoborderBaseType::allocatedMemorySize(); }

protected:
	void setVertex(LocalIndexType localIndex, GlobalIndexType globalIndex)
	{
		assert(0 <= localIndex && localIndex < borderVerticesCount);

		this->borderContainer(DimTag<0>())[localIndex] = globalIndex;
	}
};


template<typename MeshConfigTag>
class MeshEntity<MeshConfigTag, topology::Vertex> : public MeshPointerProvider<MeshConfigTag>,
                                                    public MeshEntityCoborder<MeshConfigTag, topology::Vertex>,
                                                    public IDProvider<typename MeshConfigTag::IDType, typename MeshConfigTag::GlobalIndexType>
{
	friend class EntityInitializer<MeshConfigTag, topology::Vertex>;
	friend class IOReader<MeshConfigTag>;

	typedef MeshEntityCoborder<MeshConfigTag, topology::Vertex> CoborderBaseType;

	template<DimensionType dim>
	struct CoborderRangesTag
	{
		typedef typename EntityCoborderTag<MeshConfigTag, topology::Vertex, DimTag<dim> >::RangeType      RangeType;
		typedef typename EntityCoborderTag<MeshConfigTag, topology::Vertex, DimTag<dim> >::ConstRangeType ConstRangeType;
	};

public:
	typedef MeshConfigTag    MeshConfig;
	typedef topology::Vertex Tag;

	enum { dimension = Tag::dimension };
	enum { meshDimension = MeshTag<MeshConfigTag>::dimension };

	typedef typename MeshTag<MeshConfigTag>::PointType PointType;

	PointType       &getPoint()       { return m_point; }
	const PointType &getPoint() const { return m_point; }

	template<DimensionType dim> typename CoborderRangesTag<dim>::RangeType      coborderEntities()       { return this->coborderRange(DimTag<dim>(), this->getMesh()); }
	template<DimensionType dim> typename CoborderRangesTag<dim>::ConstRangeType coborderEntities() const { return this->coborderRange(DimTag<dim>(), this->getMesh()); }

	size_t allocatedMemorySize() const { return CoborderBaseType::allocatedMemorySize(); }

protected:
	void setPoint(const PointType &point) { m_point = point; }

private:
	PointType m_point;
};


} // namespace implementation


#endif
